<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}
// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CShortcodes extends CPlugin{
	
	var $tplvars; 
	var $dynamic;

	/**
	* description array with exten
	*
	* @var type
	*
	* @access type
	*/
	var $external;
	

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $template;
	
		

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);

		global $site;

		$site->shortcodes = new Shortcodes();
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Process($content) {
		global $site , $base;


		$items = $this->db->QFetchRowArray(
			"SELECT * FROM {$this->tables['plugin:shortcodes']} WHERE shortcode_status=1"
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				switch ($val["shortcode_engine"]) {
					//external shortcodes
					case "2":
						if (!$this->external[$val["shortcode_code"]]) {
							$this->external[$val["shortcode_code"]] = new $val["shortcode_class"];
						}

						$this->dynamic[] = array(
							"code"		=> $val["shortcode_code"],
							"method"	=> array(
								&$this->external[$val["shortcode_code"]],
								"Render"
							)
						);
						
					break;

					default:
						//process device selection
						$device = explode("," , $val["shortcode_device"]);

						if (
								($base->isTablet && !in_array(2, $device)) ||
								($base->isMobile && !in_array(3, $device)) ||
								(!($base->isMobile||$base->isTablet) && !in_array(1, $device))
						) {
							$val["shortcode_multi_replace"] = $val["shortcode_replace"] = "";
						}
							

						if ($val["shortcode_multi"] && $val["shortcode_multi_replace"]) {
							$site->shortcodes->Add(
								$val["shortcode_code"]  , 
								"html" , 
								array(
									"single"	=> $val["shortcode_replace"],
									"multi"		=> $val["shortcode_multi_replace"]
								), 
								$val["shortcode_nested"]
							);

						} else {				
							$site->shortcodes->Add(
								$val["shortcode_code"]  , 
								"html" , 
								$val["shortcode_replace"] , 
								$val["shortcode_nested"]
							);
						}

					break;
				}
				

			}
		}

		//add developer codes
		$template = new CTemplateDynamic($this->tpl_path . "developer.htm");

		$site->shortcodes->Add("developer"  , "html" , $template->blockReplace("Developer"));

		if (is_array($this->dynamic)) {
			foreach ($this->dynamic as $key => $val) {

				$site->shortcodes->Add($val["code"] , "func" , $val["method"]);
			}			
		}	


		$site->shortcodes->SetContent($content);
		$site->shortcodes->Parse();

		return $this->FixHTML($site->shortcodes->GetContent());

	}	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessArray($data) {
		if (is_Array($data)) {
			foreach ($data as $key => $val) {
				if (is_array($val)) {
					$data[$key] = $this->ProcessArray($val);
				} else {
					$data[$key] = $this->Process($val);
				}				
			}		
		}

		return $data;		

	}
	
	/**
	* description tries to fix the div quotes from the paragraphs. They block the html structure on the frontend adding empty paragraphs
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function FixHTML($content) {

		//return $content;

		$replace = array(
			"<p><div",
			"</div></p>",
			"<p></div>",
			"<div></p>",
			"/a><a"

		);
		$with = array(
			"<div",
			"</div>",
			"</div>",
			"<div>",
			"/a> <a"

		);

		//cleanup spaces
		$content = preg_replace('~>\\s+<~m', '><', $content);
		$content = preg_replace('/(<div [^>]+)><\\/p>/i', '<div $1>', $content);

		return str_replace($replace , $with , $content);
	}
		
}


